/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.ugraphic.UShape;

public class UImageSvg
implements UShape {
    private final String svg;

    public UImageSvg(String svg) {
        if (svg.startsWith("<?xml")) {
            int idx = svg.indexOf("<svg");
            svg = svg.substring(idx);
        }
        this.svg = svg;
    }

    public final String getSvg() {
        if (this.svg.startsWith("<svg")) {
            int idx = this.svg.indexOf(">");
            return "<svg>" + this.svg.substring(idx + 1);
        }
        return this.svg;
    }

    private int getData(String name) {
        Pattern p = Pattern.compile("(?i)" + name + "\\W+(\\d+)");
        Matcher m = p.matcher(this.svg);
        if (m.find()) {
            String s = m.group(1);
            return Integer.parseInt(s);
        }
        throw new IllegalStateException("Cannot find " + name);
    }

    public int getHeight() {
        return this.getData("height");
    }

    public int getWidth() {
        return this.getData("width");
    }
}

